#include <stdio.h>
#include <pthread.h>
#include <stdlib.h>
#include <unistd.h>

#define AUTOMOBILI 5
#define AUTOBUSI 3
#define KAMIONI 2

int brAutomobila = 0;
int brAutobusa = 0;
int brKamiona = 0;
int smer = 0; // 0 - neodredjeno, 1 - sever, 2 - jug

pthread_mutex_t mutex;
pthread_cond_t cond;

// sever
void *passCarNorth(void *arg)
{
    long id = (long) arg;
    int time = rand() % 5;
    time++;
    sleep(time);
    printf("AUTO CEKAM: Ja sam auto sa severa %ld i stizem na nadvoznjak\n\n", id);

    pthread_mutex_lock(&mutex);
    while (brKamiona > 0 || smer == 2)
        pthread_cond_wait(&cond, &mutex);

    brAutomobila++;
    smer = 1;
    printf("AUTO PRELAZIM: Ja sam auto sa severa %ld i sad cu da predjem nadvoznjak.\n\n", id);
    pthread_mutex_unlock(&mutex);

    sleep(3);

    pthread_mutex_lock(&mutex);
    printf("AUTO PRESAO: Ja sam auto sa severa %ld i presao sam nadvoznjak.\n\n", id);
    brAutomobila--;
    if (brAutomobila == 0 && brAutobusa == 0)
    {
        smer = 0;
        pthread_cond_broadcast(&cond);
    }
    //pthread_cond_broadcast(&cond);
    pthread_mutex_unlock(&mutex);

    pthread_exit(NULL);
}

void *passBusNorth(void *arg)
{
    long id = (long) arg;
    int time = rand() % 5;
    time++;
    sleep(time);
    printf("BUS CEKAM: Ja sam bus sa severa %ld i stizem na nadvoznjak\n\n", id);

    pthread_mutex_lock(&mutex);
    while (brKamiona > 0 || brAutobusa > 0 || smer == 2)
        pthread_cond_wait(&cond, &mutex);

    brAutobusa++;
    smer = 1;
    printf("BUS PRELAZIM: Ja sam bus sa severa %ld i sad cu da predjem nadvoznjak.\n\n", id);
    pthread_mutex_unlock(&mutex);

    sleep(3);

    pthread_mutex_lock(&mutex);
    printf("BUS PRESAO: Ja sam bus sa severa %ld i presao sam nadvoznjak.\n\n", id);
    brAutobusa--;
    if (brAutomobila == 0 && brAutobusa == 0)
    {
        smer = 0;
    }
    pthread_cond_broadcast(&cond);
    pthread_mutex_unlock(&mutex);

    pthread_exit(NULL);
}

void *passTruckNorth(void *arg)
{
    long id = (long) arg;
    int time = rand() % 5;
    time++;
    sleep(time);
    printf("KAMION CEKAM: Ja sam kamion sa severa %ld i stizem na nadvoznjak\n\n", id);

    pthread_mutex_lock(&mutex);
    while (brKamiona > 0 || brAutobusa > 0 || brAutomobila > 0 || smer == 2)
        pthread_cond_wait(&cond, &mutex);

    brKamiona++;
    smer = 1;
    printf("KAMION PRELAZIM: Ja sam kamion sa severa %ld i sad cu da predjem nadvoznjak.\n\n", id);
    pthread_mutex_unlock(&mutex);

    sleep(3);

    pthread_mutex_lock(&mutex);
    printf("KAMION PRESAO: Ja sam kamion sa severa %ld i presao sam nadvoznjak.\n\n", id);
    brKamiona--;
    if (brKamiona == 0)
    {
        smer = 0;
    }
    pthread_cond_broadcast(&cond);
    pthread_mutex_unlock(&mutex);

    pthread_exit(NULL);
}

// jug
void *passCarSouth(void *arg)
{
    long id = (long) arg;
    int time = rand() % 5;
    time++;
    sleep(time);
    printf("AUTO CEKAM: Ja sam auto sa juga %ld i stizem na nadvoznjak\n\n", id);

    pthread_mutex_lock(&mutex);
    while (brKamiona > 0 || smer == 1)
        pthread_cond_wait(&cond, &mutex);

    brAutomobila++;
    smer = 2;
    printf("AUTO PRELAZIM: Ja sam auto sa juga %ld i sad cu da predjem nadvoznjak.\n\n", id);
    pthread_mutex_unlock(&mutex);

    sleep(3);

    pthread_mutex_lock(&mutex);
    printf("AUTO PRESAO: Ja sam auto sa juga %ld i presao sam nadvoznjak.\n\n", id);
    brAutomobila--;
    if (brAutomobila == 0 && brAutobusa == 0)
    {
        smer = 0;
        pthread_cond_broadcast(&cond);
    }
    //pthread_cond_broadcast(&cond);
    pthread_mutex_unlock(&mutex);

    pthread_exit(NULL);
}

void *passBusSouth(void *arg)
{
    long id = (long) arg;
    int time = rand() % 5;
    time++;
    sleep(time);
    printf("BUS CEKAM: Ja sam bus sa juga %ld i stizem na nadvoznjak\n\n", id);

    pthread_mutex_lock(&mutex);
    while (brKamiona > 0 || brAutobusa > 0 || smer == 1)
        pthread_cond_wait(&cond, &mutex);

    brAutobusa++;
    smer = 2;
    printf("BUS PRELAZIM: Ja sam bus sa juga %ld i sad cu da predjem nadvoznjak.\n\n", id);
    pthread_mutex_unlock(&mutex);

    sleep(3);

    pthread_mutex_lock(&mutex);
    printf("BUS PRESAO: Ja sam bus sa juga %ld i presao sam nadvoznjak.\n\n", id);
    brAutobusa--;
    if (brAutomobila == 0 && brAutobusa == 0)
    {
        smer = 0;
    }
    pthread_cond_broadcast(&cond);
    pthread_mutex_unlock(&mutex);

    pthread_exit(NULL);
}

void *passTruckSouth(void *arg)
{
    long id = (long) arg;
    int time = rand() % 5;
    time++;
    sleep(time);
    printf("KAMION CEKAM: Ja sam kamion sa juga %ld i stizem na nadvoznjak\n\n", id);

    pthread_mutex_lock(&mutex);
    while (brKamiona > 0 || brAutobusa > 0 || brAutomobila > 0 || smer == 1)
        pthread_cond_wait(&cond, &mutex);

    brKamiona++;
    smer = 2;
    printf("KAMION PRELAZIM: Ja sam kamion sa juga %ld i sad cu da predjem nadvoznjak.\n\n", id);
    pthread_mutex_unlock(&mutex);

    sleep(3);

    pthread_mutex_lock(&mutex);
    printf("KAMION PRESAO: Ja sam kamion sa juga %ld i presao sam nadvoznjak.\n\n", id);
    brKamiona--;
    if (brKamiona == 0)
    {
        smer = 0;
    }
    pthread_cond_broadcast(&cond);
    pthread_mutex_unlock(&mutex);

    pthread_exit(NULL);
}


int main()
{
    pthread_t threads[(AUTOMOBILI + AUTOBUSI + KAMIONI) * 2];

    pthread_mutex_init(&mutex, NULL);
    pthread_cond_init(&cond, NULL);

    // sever
    for (long i = 0; i < AUTOMOBILI; i++)
        pthread_create(threads + i, NULL, passCarNorth, (void*) i);

    for (long i = AUTOMOBILI; i < AUTOMOBILI + KAMIONI; i++)
        pthread_create(threads + i, NULL, passTruckNorth, (void*) i);

    for (long i = AUTOMOBILI + KAMIONI; i < AUTOMOBILI + KAMIONI + AUTOBUSI; i++)
        pthread_create(threads + i, NULL, passBusNorth, (void*) i);

    // jug
    int start = AUTOMOBILI + KAMIONI + AUTOBUSI;
    for (long i = start; i < start + AUTOMOBILI; i++)
        pthread_create(threads + i, NULL, passCarSouth, (void*) i);

    for (long i = start + AUTOMOBILI; i < start + AUTOMOBILI + KAMIONI; i++)
        pthread_create(threads + i, NULL, passTruckSouth, (void*) i);

    for (long i = start + AUTOMOBILI + KAMIONI; i < start + AUTOMOBILI + KAMIONI + AUTOBUSI; i++)
        pthread_create(threads + i, NULL, passBusSouth, (void*) i);

    // join
    for (long i = 0; i < (AUTOMOBILI + KAMIONI + AUTOBUSI) * 2; i++)
        pthread_join(threads[i], NULL);

    printf("Sva vozila su presla\n\n");
    return 0;
}